//## {
#pragma TXM
#define __MACRO_NAME__    "z_JOINT.c"				// tab=4
#define __MACRO_TITLE__   "TEXT JOINT"
#define __MACRO_INFO__    "̃eLXg̘A"
#define __MACRO_VER__     "2.25"					// o[W
#define __MACRO_UPDATE__  "2014/03/16"
#define __MACRO_TYPE__    "Command:   Plug-in: ~"
#define __MACRO_FOR__     "WZ 4.00F/Fe + WZ 5.03"	// mF  // ꉞ 4.00C/4.00D/4.00E/5.02l
#define __MACRO_AUTHOR__  "K-Araki"
#define __COPYRIGHT__     "Copyright(c): "
#define __WEBPAGE_URL__   "ka-web.skr.jp/"	// http://ka-web.skr.jp/
#include <_wz.h>
#include <windows.h>
// #include <windowsx.h>
////////////////////////////////////////////////////////////////////////////////
//
// 
//   Ver.1.xx o[WAbvAÂ "z_JOINT.txc" 폜邱ƁB
//   i ȑO "z_JOINT.txc" 폜ȂƎRpC삵Ȃ̂ŁBj
//
// Command
//   z_JOINT.main    "t@C̘A(&J)..."    // [t@C]j[ɂł蓖ĂƗǂHHH
//
//   R}hC  wz_main.exe /fz_JOINT.txe  ̃V[gJbgŒPƋN\B
//   F "C:\Program Files\WZ EDITOR\wz_main.exe" /fz_JOINT.txe
//   i V[gJbg̖O "WZ TEXTJOINT" ȂǂƂƗǂHBj
//
// History
//   2006/01/15: ϗ̓eLXgi"*.txt"jɋLڂ邱ƂɂB
//
////////////////////////////////////////////////////////////////////////////////


//## RpC: bZ[W
#pragma warnsignmismatch-
#pragma warnlosedigit-


//## permanentϐ
permanent txstr p_szDataDir = \"C:\WINDOWS\޽į\Ap";
permanent txstr p_szSaveDir = \"C:\WINDOWS\޽į";
//permanent txstr p_szGetExt  = ".txt;.doc;.mem;.man;.lst;.dic;.csv;.tsv;.prn;.mbx;.tmp";   //  2.00: p~
permanent BOOL  p_fAddLf       = TRUE;
permanent BOOL  p_fAddText     = FALSE;
permanent int   p_iAddTextMode = 0;
permanent BOOL  p_fBootHistDir = FALSE;
permanent BOOL  p_fNoExtBinary = TRUE;
permanent BOOL  p_fSaveCmpPath = FALSE;	// OAuAt@CvƁuۑꏊ̃pXvꏊHp
permanent int   p_iSaveKc      = 0;
permanent int   p_iSaveCr      = 0;


//## globalϐ
static TX*  g_textList;	// Xg{bNXp		// At@C̈ꗗ
static TX*  g_textBox;	// eLXg{bNXp	// ǉeLXg
static BOOL g_fSaveCode = FALSE;


//## 萔: [U[ɂύX
#define __SAVE_FILENAME__   "A.txt"	// At@C̕ۑt@C
#define __LIST_WIDTH__      76				// Xg{bNX̉(l)  // ő 100  // eLXg{bNX̐̕lɍ킹ĕωB
#define __SHELL_DIALOG__     1				// 0 or 1B  0 ɂ[tH_I]{^ WZ ̏^̃_CAOo


//## 萔: [U[qXg
// sbDelAll Ă[U[qXĝ݂͎ĉŁÂ̂Ƃ
// Ă WZ}N̏㋉҈ȊO͂̒萔͕ύXȂłB
#define __HIST_NAME__  "z_JOINT_HistPath"	// [U[qXg  //  ύXs


//## 萔: WXgp //  댯ł̂ŉςȂłB
// ȂׂŎgpĂȂÕL[ɂ  // "WZTextJoint" ŗǂȁc
#define __REGKEY_DIR__       \"Directory\shell\WZTextJoint"	// tH_  // HKCR Key
#define __REGKEY_DRIVE__     \"Drive\shell\WZTextJoint"		// hCu  // HKCR Key
#define __REGVAL_CAPTION__   "WZ TEXTJOINTŘA(&J)"		// LvṼftHg
#define __REGKEY_KEY__       "WZTextJoint"					// `FbNp


//## 萔: ID蓖: _CAOp
enum {
	IDD_MSGBOX = 201,
	IDD_LISTBOX,
	IDD_ADDLF,
	IDD_SAVEDIR,
	IDD_NOEXTBINARY,
	IDD_BOOTHISTDIR,
	IDD_CONNECT,
	IDD_HELP,

	IDD_GETLIST_SELDIR,
	IDD_GETLIST_HISTDIR,
	IDD_GETLIST_PREVDIR,

	IDD_GETDIR_DESKTOP,
	IDD_GETDIR_MYDOCS,
	IDD_GETDIR_DATADIR,

	IDD_SORT_FORWARD,
	IDD_SORT_BACK,

	IDD_MOVE_PREV,
	IDD_MOVE_NEXT,

	IDD_DEL_ONE,
	IDD_DEL_HISTALL,

	IDD_ADDTEXT,
	IDD_ADDTEXTBOX,
	IDD_ADDTEXTMODE,

	IDD_SAVECODE = 301,
	IDD_SAVEKC   = 302,
	IDD_SAVECR,

	IDD_SHELL_INSTALL = 401,
	IDD_SHELL_UNINSTALL,
	IDD_SHELL_MENUCAPTION,
	IDD_SHELL_WZPATH,
	IDD_SHELL_CLOSE,
	IDD_SHELL_SETUP,
};

//## ֐錾
int __prmSave(void);	// WZ4.00C ł͂Ő錾ƂȂƂȂHHHHH



//## _CAO̕\ʒ: Shell APICu痬p
//  HN:Sakakibara Shell APICui"shlapi.txc"j痬pĒ܂B
// wz_main.exe /fz_JOINT.txe ŒPƋNA_CAO[ɕ\̂ŁB

static void wndSetCenter(HWND hwnd)
{
	// _CAO̕\ʒ: Shell APICu痬p
	HWND hwndOwner = GetWindow(hwnd,GW_OWNER);
	if (hwndOwner) {
		mchar szClass[CCHWORD];
		GetClassName(hwndOwner,szClass,CCHWORD);
		if (!strcmp(szClass,"#32770")) {
			// I[i[_CAOȂ牽Ȃ
			return;
		}
	}
	RECT r,rWork;
	GetWindowRect(hwnd,&r);
	GetWorkRect(&rWork);
	int x,y;
	if (!hwndOwner) {
		x = (rWork.right - rectCx(&r)) / 2;
		y = (rWork.bottom - rectCy(&r)) / 2;
	} else {
		RECT rOwner;
		GetWindowRect(hwndOwner,&rOwner);
		int cx = rectCx(&r);
		int cy = rectCy(&r);
		x = rOwner.left + (rectCx(&rOwner) - cx) / 2;
		y = rOwner.top + (rectCy(&rOwner) - cy) / 2;
		if (x < 0) {
			x = 0;
		} else {
			if (x + cx > rWork.right) x = rWork.right - cx;
		}
		if (y < 0) {
			y = 0;
		} else {
			if (y + cy > rWork.bottom) y = rWork.bottom - cy;
		}
	}
	SetWindowPos(hwnd,NULL,x,y,0,0,SWP_NOSIZE|SWP_NOZORDER);
}


//## tH_̎Qƃ_CAO: Shell APICu痬p
//  HN:Sakakibara Shell APICui"shlapi.txc"j痬pĒ܂B

typedef LONG HRESULT;

typedef struct IMalloc *LPMALLOC;
struct IMallocVtbl {
	DWORD dummy[2];
	ULONG ("shell32.dll" __stdcall *Release)(LPMALLOC);
	DWORD dummy2[2];
	void ("shell32.dll" __stdcall *Free)(LPMALLOC,void*);
	DWORD dummy3[3];
} IMallocVtbl;
struct IMalloc {
	const struct IMallocVtbl *lpVtbl;
};

typedef ITEMIDLIST,*LPITEMIDLIST;
typedef const ITEMIDLIST *LPCITEMIDLIST;

typedef int (CALLBACK *BFFCALLBACK)(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData);
typedef struct {
	HWND hwndOwner;
	LPCITEMIDLIST pidlRoot;
	LPSTR pszDisplayName;
	LPCSTR lpszTitle;
	UINT ulFlags;
	BFFCALLBACK lpfn;
	LPARAM lParam;
	int iImage;
} BROWSEINFO,*LPBROWSEINFO;

#define BIF_RETURNONLYFSDIRS	0x0001
#define BFFM_INITIALIZED		1
#define BFFM_SETSELECTION		(WM_USER + 102)

extern "shell32.dll" {
	HRESULT WINAPI SHGetMalloc(LPMALLOC*);
	BOOL WINAPI SHGetPathFromIDList(LPCITEMIDLIST,LPSTR);
	LPITEMIDLIST WINAPI SHBrowseForFolder(LPBROWSEINFO);
}

static int CALLBACK SHBrowseProc(HWND hwnd,UINT uMsg,LPARAM lParam,LPARAM lpData)
{
	if (uMsg == BFFM_INITIALIZED) {
		SendMessage(hwnd,BFFM_SETSELECTION,TRUE,lpData);
		wndSetCenter(hwnd);
	}
	return 0;
}

static BOOL mySHBrowseForFolder(HWND hwndOwner,mchar* szPath,mchar* szTitle)
{
	BOOL ret = FALSE;
	LPMALLOC pMalloc;
	if (SUCCEEDED(SHGetMalloc(&pMalloc))) {
		LPITEMIDLIST pidl;
		BROWSEINFO bi;
		memset(&bi,0,sizeof(BROWSEINFO));
		bi.hwndOwner = hwndOwner;
#pragma warnfuncnotcall-
		bi.lpfn = txpcodeRegisterCallback(SHBrowseProc,4);
#pragma warnfuncnotcall+
		bi.lParam = (LPARAM)szPath;
		bi.lpszTitle = szTitle;
		bi.ulFlags = BIF_RETURNONLYFSDIRS;
		pidl = SHBrowseForFolder(&bi);
		txpcodeUnregisterCallback(bi.lpfn);
		if (pidl) {
			ret = SHGetPathFromIDList(pidl,szPath);
			(pMalloc->lpVtbl->Free)(pMalloc,pidl);
		}
		(pMalloc->lpVtbl->Release)(pMalloc);
	}
	return ret;
}


//## wv

static BOOL CALLBACK dlgprocHelp(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if (uMsg==WM_INITDIALOG) wndSetCenter(hwnd);	// wz_main.exe /fz_JOINT.txe ŒPƋNA_CAO[ɕ\̂ŒփZbg
	return FALSE;
}

static void HelpAbout(void)
{
	txstr szSaveName, szSaveExt;
	strcpy(szSaveExt,pathGetExt(__SAVE_FILENAME__));
	strcpy(szSaveName,__SAVE_FILENAME__);
	pathSetExt(szSaveName,"");

	txstr szTitle, szAuthor;
	sprintf(szTitle,"%s ( \"\m.c\" )  -  Ver.%s",__MACRO_TITLE__,__MACRO_VER__);
	sprintf(szAuthor,"%s%s i http://%s j",__COPYRIGHT__,__MACRO_AUTHOR__,__WEBPAGE_URL__);
	HDIALOG hd = dialog("Help - WZ MACRO");
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocHelp);
#pragma warnfuncnotcall+
	dialogSetNoButton(hd);
	dialogSetIntXY(hd,0,-1);
	dialogCaption(hd,szTitle);
	dialogCaption(hd,"mF: "   + __MACRO_FOR__);
	dialogCaption(hd,"LastUpdate: " + __MACRO_UPDATE__);
	dialogCaption(hd,szAuthor);
	dialogSetPosY(hd,dialogGetPosY(hd)+8);
	dialogCaption(hd," ");
	dialogCaption(hd,"@@w̃tH_̃̕t@C PɘAāAw̃tH_");
	dialogCaption(hd,"@@\""+szSaveName+szSaveExt+"\"@Ƃt@Cŕۑ܂B");
	dialogCaption(hd,"@@i Ãt@C͕ҏW폜܂B)");
	dialogCaption(hd,"@@łɓÕt@C݂鎞́Aɔԍǉĕۑ܂B");
	dialogCaption(hd,"@@i F@\""+szSaveName+szSaveExt+"\"  \""+szSaveName+"(2)"+szSaveExt+"\"  \""+szSaveName+"(3)"+szSaveExt+"\" j");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"uNɑÕtH_ǂݍ݁v `FbN{bNX");
	dialogCaption(hd,"@@OFF ̎́Ã݂̕tH_̃t@CꗗǂݍŋN܂B");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"uoCi͓ǂݍ܂Ȃv`FbN{bNX");
	dialogCaption(hd,"@@ON  ̎́AWZ ̊ݒ -uoCit@C̊gqv ̃t@Cꗗ");
	dialogCaption(hd,"@@ǂݍ݂܂Bi ʏ ON ɂĂĂB j");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"u...AɎ̃eLXgǉv`FbN{bNX");
	dialogCaption(hd,"@@eLXg{bNX̓e û܂܁v }܂̂ŁAsǉꍇ");
	dialogCaption(hd,"@@͕ɉsYȂ悤ɂĂB ");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"uۑ̕R[hwv`FbN{bNX");
	dialogCaption(hd,"@@OFF ̎́AAPڂ̃t@C̕R[hŕۑ܂B");
	dialogCaption(hd,"@@ʏ OFF ɂĂāAɎw肷Kv鎞̂ ON ɂĂB");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"uShello^v{^");
	dialogCaption(hd,"@@Windows ̃GNXv[̃tH_̉ENbNj[ɘAR}ho^");
	dialogCaption(hd,"@@邽߂̃_CAOJ܂B");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"̑Aڍׂ̓eLXg \"\m.txt\" B");
	dialogResetInt(hd);
	dialogOpen(hd);
}


//## WXg̓`FbNp

static BOOL CheckShellInstallTextJointKey(HKEY _hkey, txstr szKey)
{
	// _hkey  szKey ̃`FbN  // Cx
	// G[̎ TRUE Ԃ
	if (_hkey!=HKEY_CLASSES_ROOT || (strnicmp(szKey,"Drive\\Shell\\",12)!=0 && strnicmp(szKey,"Directory\\Shell\\",16)!=0)) {
		MessageBox(GetActiveWindow(),
			"vOG[F _hkey  szKey słB\n\n"
			"EHKEY_CLASSES_ROOT\\Drive\\Shell\\\n"
			"EHKEY_CLASSES_ROOT\\Directory\\Shell\\\n\n"
			"ȊO͑ł܂B\n"
			,"\m.c"
			,MB_OK|MB_ICONSTOP
		);
		return TRUE;
	}
	if (!stristr(szKey,"\\"+__REGKEY_KEY__)) {
		MessageBox(GetActiveWindow(),
			"vOG[F szKey słB\n\n"
			"szKey  \"\\" + __REGKEY_KEY__ + "\" ܂܂Ă܂B\n\n"
			"( szKey: \"" + szKey + "\" )"
			,"\m.c"
			,MB_OK|MB_ICONSTOP
		);
		return TRUE;
	}
	if (!stristr(szKey,"\\WZTextJoint")) {
		MessageBox(GetActiveWindow(),
			"vOG[F szKey słB\n\n"
			"szKey  \"\\WZTextJoint\" ܂܂Ă܂B\n\n"
			"( szKey: \"" + szKey + "\" )"
			,"\m.c"
			,MB_OK|MB_ICONSTOP
		);
		return TRUE;
	}
	if (strchr(szKey,' ')) {
		MessageBox(GetActiveWindow(),
			"vOG[F szKey słB\n\n"
			"szKey ɃXy[X܂ނƂ͂ł܂B\n\n"
			"( szKey: \"" + szKey + "\" )"
			,"\m.c"
			,MB_OK|MB_ICONSTOP
		);
		return TRUE;
	}
	return FALSE;
}


//## WXgp
// HN:y.mikome "regwz4.txc" QlɂB

extern "advapi32.dll" RegOpenKeyA;
extern "advapi32.dll" RegOpenKeyExA;
extern "advapi32.dll" RegCreateKeyA;
extern "advapi32.dll" RegCreateKeyExA;
extern "advapi32.dll" RegQueryValueA;
extern "advapi32.dll" RegQueryValueExA;
extern "advapi32.dll" RegSetValueA;
extern "advapi32.dll" RegSetValueExA;
extern "advapi32.dll" RegDeleteKeyA;
extern "advapi32.dll" RegDeleteKeyExA;
extern "advapi32.dll" RegCloseKey;

static BOOL GetValue(HKEY _hkey, txstr szKey, txstr szName, txstr szValue)
{
	// _hkey\szKey  szNamel  ""  szValue Ɏ擾
	BOOL ret =  FALSE;
	HKEY hkey;
	int len = CCHPATHNAME;
	if (RegOpenKeyEx(_hkey,szKey,0,KEY_ALL_ACCESS,&hkey)==ERROR_SUCCESS) {
		DWORD dwType = REG_SZ;
		ret = (RegQueryValueEx(hkey,szName,NULL,&dwType,(PBYTE)szValue,&len)==ERROR_SUCCESS);
		RegCloseKey(hkey);
	}
	return ret;
}

static BOOL GetKey(HKEY _hkey, txstr szKey)
{
	// _hkey\szKey ݂邩Ԃ
	HKEY hkey;
	BOOL ret = FALSE;
	if (RegOpenKeyEx(_hkey,szKey,0,KEY_ALL_ACCESS,&hkey)==ERROR_SUCCESS) {
		RegCloseKey(hkey);
		ret = TRUE;
	}
	return ret;
}

static BOOL DeleteKey(HKEY _hkey, txstr szKey)
{
	// _hkey\szKey 폜

	if (CheckShellInstallTextJointKey(_hkey,szKey)) return FALSE;
	// {}NŗL̍׍H  // _hkey  szKey ̃`FbN

	BOOL ret =  FALSE;
	ret = (RegDeleteKey(_hkey,szKey)==ERROR_SUCCESS);
	return ret;
}

static BOOL SetValue(HKEY _hkey, txstr szKey, txstr szName, txstr szValue)
{
	// _hkey\szKey  szNamel  ""  szValue ɃZbg

	if (CheckShellInstallTextJointKey(_hkey,szKey)) return FALSE;
	// {}NŗL̍׍H  // _hkey  szKey ̃`FbN

	HKEY hkey;
	BOOL ret = FALSE;
	if (RegCreateKey(_hkey,szKey,&hkey)==ERROR_SUCCESS) {
		ret = (RegSetValueEx(hkey,szName,NULL,REG_SZ,szValue,strlen(szValue)+1)==ERROR_SUCCESS);
		RegCloseKey(hkey);
	}
	return ret;
}



//## Shellj[o^

static BOOL ShellInstallTextJoint(txstr szWzPath, txstr szValCaption)
{
	// Shellj[o^
	// Windows̃GNXv[̃tH_̉ENbNj[ɘAR}h({}N)ǉ

	// szWzPath     = WZCXg[tH_̃pX
	// szValCaption = j[ɕ\閼O

	#define MAX_CAPTIONSIZE  26	// szValCaption őoCg
	#define MIN_CAPTIONSIZE   4	// szValCaption ŏoCg

	szValCaption = strGetWordTop(szValCaption);
	if (strlen(szValCaption) > MAX_CAPTIONSIZE) szValCaption = strleft(szValCaption,MAX_CAPTIONSIZE);
	if ((strlen(szValCaption) < MIN_CAPTIONSIZE) && MessageBox(GetActiveWindow(),"[j[ɕ\閼O]  4ȏɂĂB","\m.c - Shellj[o^",MB_OK|MB_ICONINFORMATION)) return FALSE;

	txstr szWzExePath; // "wz_main.exe" ̃pX
	pathFormDir(szWzPath);
	sprintf(szWzExePath,"%s\\wz_main.exe",szWzPath);
	if (!fileIsExist(szWzExePath) && MessageBox(GetActiveWindow(),"\"" + szWzPath + "\"\n\ñtH_ɂ \"wz_main.exe\" ݂܂B\n\nWZ EDITOR CXg[tH_w肵ĂB","\m.c - Shellj[o^",MB_OK|MB_ICONINFORMATION))  return FALSE;

	if (MessageBox(GetActiveWindow(),"GNXv[̃tH_̉ENbNj[\nu" + szValCaption + "vǉ܂B\n\nsĂ낵H","\m.c - mF",MB_OKCANCEL|MB_ICONQUESTION)!=IDOK) return FALSE;

	txstr szValCmd;   // o^R}hC
	sprintf(szValCmd,"\"%s\\wz_main.exe\" /f\m.txe -f\"%%1\"",szWzPath);	// o^R}hC

	txstr szKeyDir = __REGKEY_DIR__;
	txstr szKeyDirCmd;
	sprintf(szKeyDirCmd,"%s\\Command",szKeyDir);

	txstr szKeyDrive = __REGKEY_DRIVE__;
	txstr szKeyDriveCmd;
	sprintf(szKeyDriveCmd,"%s\\Command",szKeyDrive);

//	//----- mFp ------
//	information(
//		"Test Information - REG HKCR\n\n"
//		"[Directory]\nKey: %s\nValue: %s\nKey: %s\nValue: %s\n\n"
//		"[Drive Install]\nKey: %s\nValue: %s\nKey: %s\nValue: %s\n"
//		,szKeyDir,   szValCaption, szKeyDirCmd,   szValDirCmd
//		,szKeyDrive, szValCaption, szKeyDriveCmd, szValCmd
//	); return TRUE;

	if (
		SetValue(HKEY_CLASSES_ROOT,szKeyDir,     NULL,szValCaption)  &&
		SetValue(HKEY_CLASSES_ROOT,szKeyDirCmd,  NULL,szValCmd)   &&
		SetValue(HKEY_CLASSES_ROOT,szKeyDrive,   NULL,szValCaption)  &&
		SetValue(HKEY_CLASSES_ROOT,szKeyDriveCmd,NULL,szValCmd)
		) {
		MessageBox(GetActiveWindow(),
			"tH_̉ENbNj[Ɂu" + szValCaption + "v\n"
			"o^܂B\n\n"
			"KȃtH_̉ENbNj[ WZ GREP N\n"
			"ł邩mFĂB"
			,"\m.c - Shellj[o^"
			,MB_OK|MB_ICONINFORMATION
		);
	} else {
		MessageBox(GetActiveWindow(),
			"tH_̉ENbNj[ւ̓o^Ɏs܂B\n\n"
			"{}N̕s̉\܂̂ŏC܂\n"
			"̃j[o^@\͎gpȂłB"
			,"\m.c - Shellj[o^s"
			,MB_OK|MB_ICONSTOP
		);
	}
	return  TRUE;
}

static BOOL ShellUnInstallTextJoint(void)
{
	// Shellj[o^폜
	// ({}N) Windows̃GNXv[̃tH_̉ENbNj[ɓo^AR}h폜

	if (MessageBox(GetActiveWindow(),
		"GNXv[̃tH_̉ENbNj[\n"
		"{}Nœo^ AR}h폜܂B\n\n"
		"sĂ낵H"
		,"\m.c - mF"
		,MB_OKCANCEL|MB_ICONQUESTION)!=IDOK
		) return  FALSE;

	txstr szKeyDir   = __REGKEY_DIR__;
	txstr szKeyDirCmd;
	sprintf(szKeyDirCmd,"%s\\Command",szKeyDir);

	txstr szKeyDrive = __REGKEY_DRIVE__;
	txstr szKeyDriveCmd;
	sprintf(szKeyDriveCmd,"%s\\Command",szKeyDrive);

//	//----- mFp ------
//	information(
//		"Test Information - REG HKCR\n\n"
//		"[Directory]\nKey: %s\n\n"
//		"[Drive]\nKey: %s\n"
//		,szKeyDir
//		,szKeyDrive
//	); return TRUE;

	if (GetKey(HKEY_CLASSES_ROOT,szKeyDir) || GetKey(HKEY_CLASSES_ROOT,szKeyDrive)) {
		if (GetKey(HKEY_CLASSES_ROOT,szKeyDir)) {
			DeleteKey(HKEY_CLASSES_ROOT,szKeyDirCmd);
			DeleteKey(HKEY_CLASSES_ROOT,szKeyDir);
		}
		if (GetKey(HKEY_CLASSES_ROOT,szKeyDrive)) {
			DeleteKey(HKEY_CLASSES_ROOT,szKeyDriveCmd);
			DeleteKey(HKEY_CLASSES_ROOT,szKeyDrive);
		}
		MessageBox(GetActiveWindow(),
			"tH_̉ENbNj[ AR}h\n"
			"폜܂B\n\n"
			"KȃtH_ENbNăj[폜\n"
			"Ă邱ƂmFĂB"
			,"\m.c - Shellj[o^̉"
			,MB_OK|MB_ICONINFORMATION
		);
	} else {
		MessageBox(GetActiveWindow(),
			"tH_̉ENbNj[ɖ{}Nœo^\n"
			"R}h܂łB\n\n"
			"㋉җpF Windows̃WXgɁAAA\n\n"
			"[HKEY_CLASSES_ROOT\\" + szKeyDir + "]\n"
			"[HKEY_CLASSES_ROOT\\" + szKeyDrive + "]\n"
			"̃L[݂܂B"
			,"\m.c - Shellj[o^̉"
			,MB_OK|MB_ICONINFORMATION
		);
	}
	return TRUE;
}

static BOOL CALLBACK dlgprocShellInstall(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {

		case WM_INITDIALOG:
			wndSetCenter(hwnd);	// wz_main.exe /fz_JOINT.txe ŒPƋNA_CAO[ɕ\̂ŒփZbg
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDD_SHELL_INSTALL: {
					txstr szWzPath, szValCaption;
					GetDlgItemText_A(hwnd,IDD_SHELL_WZPATH,szWzPath,CCHPATHNAME);
					GetDlgItemText_A(hwnd,IDD_SHELL_MENUCAPTION,szValCaption,CCHWORD);
					//information("%s\n%s",szWzPath,szValCaption); break;
					if (!ShellInstallTextJoint(szWzPath,szValCaption)) return TRUE;
					break;
				}
				case IDD_SHELL_UNINSTALL:
					if (!ShellUnInstallTextJoint()) return TRUE;
					break;
			}
			break;

	}
	return FALSE;
}

static void ShellInstallTextJointDialog(void)
{
	txstr szValCaption = __REGVAL_CAPTION__;
	txstr szWzPath;
	pathFullExedir(szWzPath,"");
	// szWzPath = "wz_main.exe" ̃tH_̃pX
	if (strlen(szWzPath)>3) pathFormDir(szWzPath);

	int lcx = 15, lcxBox = 45;
	HDIALOG hd = dialog("\m.c - Shellj[o^");
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocShellInstall);
#pragma warnfuncnotcall+
	dialogSetFocus(hd,IDD_SHELL_CLOSE);
	dialogSetNoButton(hd);

	dialogHeadline(hd,"Shellj[o^",lcxBox);
	dialogCaption(hd," [o^] {^ ƁA [o^e] ");
	dialogSetPosY(hd,dialogGetPosY(hd)-2);
	dialogCaption(hd,"GNXv[  tH_  ENbNj[ ");
	dialogSetPosY(hd,dialogGetPosY(hd)-2);
	dialogCaption(hd,"AR}h o^܂B");
	dialogSpace(hd);
	dialogCaption(hd,"o^  j[sƁÃtH_ ");
	dialogSetPosY(hd,dialogGetPosY(hd)-2);
	dialogCaption(hd,"t@Cꗗ  ǂݍ {}N N܂B");
	dialogSpace(hd);
	dialogCaption(hd,"i  Kv̂Ȃ͎sȂłBj");
	dialogSpace(hd);

	dialogSetH(hd);
	dialogControlID(hd,IDD_SHELL_INSTALL);
	dialogCmd(hd,"o^ (&Y)",lcx);
	dialogControlID(hd,IDD_SHELL_UNINSTALL);
	dialogCmd(hd,"o^ (&D)",lcx);
	dialogSpace(hd);
	dialogSpace(hd);
	dialogControlID(hd,IDD_SHELL_CLOSE);
	dialogClose(hd,lcx-4);
	dialogLFSetV(hd);

	dialogSpace(hd);
	dialogSpace(hd);
	dialogSpace(hd);

	dialogHeadline(hd,"o^e",lcxBox);
	dialogCaption(hd,"j[ɕ\閼O :@( pZ@26  ȓ )");
	dialogSetPosY(hd,dialogGetPosY(hd)-1);
	dialogControlID(hd,IDD_SHELL_MENUCAPTION);
	dialogTxstr(hd,NULL,0,szValCaption,lcxBox);
	dialogCaption(hd,"( F@WZŘA(&&J) A@WZ MacroŘA(&&J) )");
	dialogSpace(hd);
	dialogCaption(hd,"WZ EDITOR CXg[ꏊ :");
	dialogSetPosY(hd,dialogGetPosY(hd)-1);

	dialogControlStyle(hd,ES_READONLY);
		dialogControlID(hd,IDD_SHELL_WZPATH);
		dialogControlRefer(hd,"-d");
		// pathFullExedir ŃpX擾̂ŕKvȂǁuꉞvtH_̎Qƃ{^ǉ
		dialogTxstr(hd,NULL,0,szWzPath,lcxBox);
	dialogControlStyle(hd,0);

	dialogCaption(hd,"i ȂΉẼ{^ŃtH_I j");

	dialogOpen(hd);
}


//## ShelltH_̃pX擾

static BOOL GetShellPath(int i, txstr szShellPath)
{
	// szShellPath  iԍ ShelltH_̃pX擾
	txstr szName;
	if      (i==0)  szName = "Desktop";			// fXNgbv
	else if (i==1)  szName = "Personal";		// }C hLg
//	else if (i==2)  szName = "My Pictures";		// My Pictures
//	else if (i==3)  szName = "Start Menu";		// X^[gj[
//	else if (i==4)  szName = "Programs";		// X^[gj[ - vO
//	else if (i==5)  szName = "SendTo";			// SendTo
//	else if (i==6)  szName = "Recent";			// Recent
//	else if (i==7)  szName = "Favorites";		// IE Favorites
//	else if (i==8)  szName = "Cache";			// IE Cache
//	else if (i==9)  szName = "History";			// IE History
//	else if (i==10) szName = "Cookies";			// IE Cookies
//	else if (i==11) szName = "AppData";			// AppData
//	else if (i==12) szName = "Local AppData";	// Local AppData
//	else if (i==13) szName = "Templates";		// Shell New
	else return FALSE;
	txstr szValue, szKey = \"Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders";
	if (GetValue(HKEY_CURRENT_USER,szKey,szName,szValue)) {
		szShellPath = szValue;
		return TRUE;
	}
	return FALSE;
}


//## ǉeLXg̃pX

static void SetAddTextPath(txstr szAddTextPath)
{
	// szAddTextPath ɒǉeLXg̃tpXZbg
	// wz:\macro\ + {}Nt@C̊gq .tmp ɂ	// "z_JOINT.tmp"
	pathFullExedir(szAddTextPath,"macro\\\m.tmp");
}


//## A

static BOOL SavePathTo(TX* text, txstr szSaveDir, txstr szSaveName, txstr szSavePath)
{
	// At@C̕ۑ
	// text  szSaveDir tH_  szSaveName ̖Oŕۑ
	// łɑ݂鎞̓t@C̖ɔԍǉĕۑ  //  file(2).txt -> file(3).txt ...
	pathFormDir(szSaveDir);
	sprintf(szSavePath,"%s\\%s",szSaveDir,szSaveName);
	if (fileIsExist(szSavePath)) {
		int iFile = 1;
		while (1) {
			iFile++;
			txstr szTmpSaveName = pathGetFileName(szSaveName);
			txstr szExt = pathGetExt(szSaveName);
			pathSetExt(szTmpSaveName,"");
			sprintf(szSavePath,"%s\\%s(%d)%s",szSaveDir,szTmpSaveName,iFile,szExt);
			if (!fileIsExist(szSavePath)) break;
		}
	}
	if (!txSaveTo(text,szSavePath)) return FALSE;
	return TRUE;
}

static void ReplaceMacroWord(TX* textTmp, txstr szPath, int i)
{
	// textTmp ̃}N̒u	// ǉeLXg̃}N̒u
	txstr szFileName = "%f", szFileNo = "%i";
	// "%f" = szPath ́ut@Ĉ݁vɒu
	// "%i" = i ̔ԍ(l)𕶎ɒu
	txstr szName = pathGetFileName(szPath), szNo = inttostr(i);
	DWORD mode = SEARCH_NOSELECT;
	txJumpFileTop(textTmp);
	if (txSearchEx(textTmp,szFileNo,mode))   txReplaceEx(textTmp,szFileNo,szNo,SEARCH_ALL);
	txJumpFileTop(textTmp);
	if (txSearchEx(textTmp,szFileName,mode)) txReplaceEx(textTmp,szFileName,szName,SEARCH_ALL);
}

static BOOL CheckSaveName(txstr szSaveName)
{
	// szSaveName(t@C) ̃`FbN
	txstr szNoNameChar = "\\/:,;*?\"<>|", szNoNameCharMsg = "\\ / : , ; * ? \" < > |";
	szSaveName = strGetWordTop(szSaveName);
	if (!strlen(szSaveName) && MessageBox(GetActiveWindow(),"At@C̕ۑt@Cw肳Ă܂B","\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
	if (strchrs(szSaveName,szNoNameChar) && MessageBox(GetActiveWindow(),"At@C̕ۑt@CɎ͎̕g܂B\n\n" + szNoNameCharMsg, "\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
	return FALSE;
}

static BOOL CheckSaveDirPath(txstr szSaveDir)
{
	// szSaveDir(tH_̃pX) ̃`FbN
	txstr szNoDirChar  = ",;*?\"<>|", szNoDirCharMsg  = ", ; * ? \" < > |";
	szSaveDir = strGetWordTop(szSaveDir);
	if (strlen(szSaveDir)>3) pathFormDir(szSaveDir);
	if (strchrs(szSaveDir,szNoDirChar) && MessageBox(GetActiveWindow(),"At@C̕ۑꏊ(tH_)̃pX\n͎̕g܂B\n\n" + szNoDirCharMsg, "\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
	if ((strlen(szSaveDir)<3 || !isalpha(*strGetWordTop(szSaveDir)) || !strchrs(szSaveDir,"\\:") || !strstr(szSaveDir,":\\")) && MessageBox(GetActiveWindow(),"At@C̕ۑꏊ̓tpXŎw肵ĂB","\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
	if (!pathIsDirectory(szSaveDir)) {
		if (strlen(szSaveDir)<4 && MessageBox(GetActiveWindow(),"At@C̕ۑꏊ\n݂hCũpXw肵ĂB","\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
		if (MessageBox(GetActiveWindow(),"At@C̕ۑꏊ\n\n\""+szSaveDir+"\"\n\ñtH_݂͑܂B\n\ntH_쐬܂H","\m.c - mF",MB_YESNO|MB_ICONQUESTION)!=IDYES) return TRUE;
		if (mkdir(szSaveDir)!=0 && MessageBox(GetActiveWindow(),szSaveDir+"\n\ñtH_쐬ł܂B\n\npX̕񂪐mFĂB","\m.c",MB_OK|MB_ICONSTOP)) return TRUE;
	}
	return FALSE;
}

static BOOL ConnectListFile(
	HWND hwndMsgBox, TX* textList, TX* textBox, txstr szSaveDir, txstr szSaveName,
	BOOL fAddLf, BOOL fAddText, BOOL fAddTextEnd, BOOL fCode, int iKc, int iCr)
{
	// A
	// textList ̊es̃pX̃t@CA szSaveDir tH_  szSaveName ̃t@Cŕۑ
	// i szSaveDir/szSaveName Ƀ_uNH[e[V("")ň͂܂Ȃ j

	// hwndMsgBox  = bZ[W{bNX	// dialogCaptionDynamic

	// fAddLf      = Aɉs݂ȂɉsǉH

	// fAddText    = A textBox ̓eǉH
	// fAddTextEnd = fAddText ɕɒǉH  // FALSE = 

	// fCode = ۑ̕R[hƉsR[hwH

		// iKc = fCode ̕R[h:
		//   KC_... = "_wz.h"̒`
		//   0 = KC_SJIS
		//   1 = KC_JIS
		//   2 = KC_EUC
		//   3 = KC_UNICODE      // 
		//   4 = KC_UNICODEBETA  // 
		//   5 = KC_UTF8         // WZ4SJISň镶̂
		//   6 = KC_EURO         // WZ5̂
		// iCr = fCode ̉sR[h:
		//   RETURNCODE_... = "_wz.h"̒`
		//   0 = RETURNCODE_CRLF
		//   1 = RETURNCODE_CR
		//   2 = RETURNCODE_LF

	#define SELECT_CR  2
#if WZFUNC_TX3
	#define SELECT_KC  6
#else
	#define SELECT_KC  5
#endif
	if ((iKc>SELECT_KC || iCr>SELECT_CR) && MessageBox(GetActiveWindow(),"vOG[F ֐̈̐lől𒴂Ă܂B","\m.c - /sR[hw",MB_OK|MB_ICONSTOP)) return FALSE;

	if (CheckSaveName(szSaveName) || CheckSaveDirPath(szSaveDir)) return FALSE;
	// szSaveDir  szSaveName ̃`FbN

	#define MAX_ADDTEXTSIZE 10240	// textBox(ǉeLXg)̍őoCg  // 10240 = 10KB
	if (!txGetTextSize(textList) && MessageBox(GetActiveWindow(),"At@C̃XgłB","\m.c",MB_OK|MB_ICONSTOP)) return FALSE;
	if (fAddText && txGetTextSize(textBox) > MAX_ADDTEXTSIZE && MessageBox(GetActiveWindow(),"AɒǉuǉeLXgṽTCY\nőoCǵ@10 KB@𒴂Ă܂B","\m.c",MB_OK|MB_ICONSTOP)) return FALSE;
	txJumpFileEnd(textList);
	if (textList->npara < 3 && MessageBox(GetActiveWindow(),"At@CQȏ㑶݂Ȃ\nA͎sł܂B","\m.c",MB_OK|MB_ICONSTOP)) return FALSE;

	txSetBusy(textList);
	txJumpFileTop(textList);

	TX* textConnect = textnew();
	// textConnect = At@C쐬p

	txstr szMsg;
	BOOL fStopEsc = FALSE;
	int i=0;
	while (!txIsCurEof(textList)) {
		if (GetAsyncKeyState(VK_ESCAPE) < 0) {
			fStopEsc = TRUE;
			break;
		}
		txstr szDataPath;	// szDataPath = At@C
		if (txGetPara(textList,szDataPath)) {
			if (fileIsExist(szDataPath)) {
				sprintf(szMsg,"%d A ...i  {ESC} L[ ŘA~  j",i);
				SetWindowText(hwndMsgBox,szMsg);
	
				TX* textTmp = textopenEx(szDataPath,TXO_KCAUTO | TXO_CRAUTO);
				// textTmp = At@Cp  // textopenEx = R[hF
				if (txGetTextSize(textTmp)) {
					if (i==0) {
						if (fCode) textConnect->kcSave = iKc, textConnect->crSave = iCr;
						else       textConnect->kcSave = textTmp->kcSave, textConnect->crSave = textTmp->crSave;
						// R[hw肵Ȃ Pڂ̃t@C̕R[hZbg
					}
					if (fAddText && txGetTextSize(textBox)) {
					// ǉeLXg textBox ǉ
						TX* textBoxTmp = textnew();	// textBoxTmp = textBox ̍Ɨp
						txInsertText(textBoxTmp,textBox);
						ReplaceMacroWord(textBoxTmp,szDataPath,i+1);	// }N̒u
						if (fAddTextEnd) {
						// textBox  textTmp ֒̕ǉꍇ
							txInsertText(textConnect,textTmp);
							if (fAddLf && !txIsCurParaTop(textConnect)) txInsertReturn(textConnect);
							txInsertText(textConnect,textBoxTmp);
						} else {
						// textBox  textTmp ֒̕ǉꍇ
							txInsertText(textConnect,textBoxTmp);
							txInsertText(textConnect,textTmp);
						}
						textclose(textBoxTmp);
					} else {
					// ǉeLXgȂ
						txInsertText(textConnect,textTmp);
					}
					if (fAddLf && !txIsCurParaTop(textConnect)) txInsertReturn(textConnect);
				}
				textclose(textTmp);
				i++;
			} else {
				MessageBox(GetActiveWindow(),szDataPath+"\"\n\n݂͑܂B\n\nXLbv܂B","\m.c",MB_OK|MB_ICONSTOP);
			}
		}
		if (!txNextPara(textList)) break;
	}

	txstr szSavePath;
	BOOL ret = SavePathTo(textConnect,szSaveDir,szSaveName,szSavePath);

	textclose(textConnect);
	txSetUnbusy(textList);

	if (ret) {
		sprintf(szMsg,"A - %d A",i);
		SetWindowText(hwndMsgBox,szMsg);
		if (fStopEsc) {
			if (MessageBox(GetActiveWindow(),"{ESC} L[ŘA𒆎~܂B\ni ׂẴt@C͘A܂łBj\n\n\""+szSavePath+"\"\n\n쐬܂B\n\n쐬t@C WZ ŊJ܂H",szMsg,MB_YESNO|MB_ICONQUESTION)==IDYES) forkstd(szSavePath,NULL);
		} else {
			if (MessageBox(GetActiveWindow(),"\""+szSavePath+"\"\n\n쐬܂B\n\n쐬t@C WZ ŊJ܂H",szMsg,MB_YESNO|MB_ICONQUESTION)==IDYES) forkstd(szSavePath,NULL);
		}
	} else {
		sprintf(szMsg,"As - %d A",i);
		SetWindowText(hwndMsgBox,szMsg);
		MessageBox(GetActiveWindow(),"\""+szSavePath+"\"\n\n̕ۑɍ쐬܂B",szMsg,MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	return TRUE;
}


//## AXg̍쐬

static int GetFileList(TX* textList, txstr szDataDir, BOOL fNoExtBinary)
{
	// textList  szDataDir tH_̃t@C(tpX)̈ꗗ}
	// fNoExtBinary = oCi̊gq̃t@Cǂݍ܂ȂH  // WZ̊ݒ̃oCi̊gq
	txstr szDataPath;
	if (strlen(szDataDir)>3) pathFormDir(szDataDir);
	if (pathIsDirectory(szDataDir)) {
		pathFormDir(szDataDir);
		sprintf(szDataPath,"%s\\*.*",szDataDir);
	} else {
		MessageBox(GetActiveWindow(),"\""+szDataDir+"\"\n\ñtH_݂͑܂܂B\n\nAt@C̃tH_w肵ĂB",__MACRO_TITLE__+"(\"\m.c\")",MB_OK|MB_ICONINFORMATION);
		return 0;
	}

	txDeleteText(textList);
	int i = 0;
	HANDLE hFindFile = INVALID_HANDLE_VALUE;
	WIN32_FIND_DATA filefind;
	hFindFile = FindFirstFile(szDataPath,&filefind);
	if (hFindFile != INVALID_HANDLE_VALUE) {
		while (1) {
			if (!FindNextFile(hFindFile,&filefind)) break;
			txstr szfilename = filefind.cFileName;
			pathSetFileName(szDataPath,szfilename);
			if (!pathIsDirectory(szDataPath)) {
				txstr szExt = pathGetExt(szDataPath);
				if (fNoExtBinary) {
				// oCiǂݍ܂Ȃ
					txstr szExtBinary = sh->cszExtBinary;
					if (!strlen(szExt) || (strcmp(szExt,".")!=0 && !stristr(szExtBinary+";",szExt+";"))) {
						txInsertf(textList,"%s\n",szDataPath);
						i++;
					}
				} else {
					if (!strlen(szExt) || strcmp(szExt,".")!=0) {
						txInsertf(textList,"%s\n",szDataPath);
						i++;
					}
				}
			}
		}
		FindClose(hFindFile);
	}
	if (i==0) {
		if (fNoExtBinary) MessageBox(GetActiveWindow(),"\""+szDataDir+"\"\n\nɂ̓t@CP݂܂B\n\nioCi̊gq̃t@Cǂݍ܂Ȃ ON łj\n\nAt@C̃tH_w肵ĂB",__MACRO_TITLE__+"(\"\m.c\")",MB_OK|MB_ICONINFORMATION);
		else              MessageBox(GetActiveWindow(),"\""+szDataDir+"\"\n\nɂ̓t@CP݂܂B\n\nAt@C̃tH_w肵ĂB",__MACRO_TITLE__+"(\"\m.c\")",MB_OK|MB_ICONINFORMATION);
	}
	return i;
}


//## _CAO

static BOOL CALLBACK dlgprocHist(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {

		case WM_INITDIALOG:
			wndSetCenter(hwnd);	// wz_main.exe /fz_JOINT.txe ŒPƋNA_CAO[ɕ\̂ŒփZbg
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDD_DEL_HISTALL:
					if (MessageBox(GetActiveWindow(),"ŋ߁AAɎgtH_ׂ̗č폜܂B\n\nsĂ낵H","\m.c",MB_YESNO|MB_ICONQUESTION)==IDYES) {
						HSTRBLK sb = historyOpen(__HIST_NAME__,512);
						sbDelAll(sb);
						historyClose(__HIST_NAME__,sb);
					}
					break;
			}
			break;

	}
	return FALSE;
}

static BOOL GetHistPathDialog(txstr szPath)
{
	// _CAO
	// OK ꂽ szPath ɑIpX擾 TRUE Ԃ
	TX* textTmp = textnew();

	HSTRBLK sb = historyOpen(__HIST_NAME__,512);
	txstr sz;
	int i;
	//-------------
	// ܂: "޽į\Ap" ͏펞\
	txstr szShellPath;
	if (GetShellPath(0,szShellPath)) {
		if (strlen(szShellPath)) {
			pathFormDir(szShellPath);
			if (strlen(szShellPath)) sbAddHist(sb,szShellPath+"\\Ap");
		}
	}
	//-------------
	for (i=0; i<sbGetCount(sb); i++) {
		sprintf(sz,"%s\n",sbRead(sb,i));
		txCurInsertBuff(textTmp,sz,strlen(sz));
	}
	historyClose(__HIST_NAME__,sb);

	#define MAX_LISTWIDTH  100		// Xg{bNX̉̍ől
	int idList, lcx = 11, lcxBox = __LIST_WIDTH__ > MAX_LISTWIDTH ? MAX_LISTWIDTH : __LIST_WIDTH__;

	HDIALOG hd = dialog("ŋ߁AAɎgtH_");
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocHist);
#pragma warnfuncnotcall+

	idList = dialogList(hd,NULL,textTmp,__LIST_WIDTH__ + 8,16);
	dialogSetNotifyAsOK(hd,idList,LBN_DBLCLK);

	dialogSetPosY(hd,dialogGetPosY(hd)-2);
	dialogCaption(hd,"^Ƃā@\"...\\fXNgbv\\Ap\"@͏펞ꗗɕ\܂B");
	dialogLFV(hd);

	dialogOK(hd,lcx);
	dialogCancel(hd,lcx);
	dialogSpace(hd);
	dialogSpace(hd);
	dialogSpace(hd);
	dialogControlID(hd,IDD_DEL_HISTALL);
	dialogCmd(hd,"NA(&D)",lcx);

	BOOL ret = FALSE;
	if (dialogOpen(hd)==IDOK) ret = txGetPara(textTmp,szPath);
	textclose(textTmp);
	return ret;
}


//## C_CAO

static BOOL SortList(TX* textList, BOOL fBack)
{
	// textList ̃\[g
	// fBack = ~H
	if (txGetTextSize(textList)<2) return FALSE;
	SORTARG arg;
	structClear(arg);
	arg.sizeStruct = sizeof(SORTARG);
	arg.lineTop = 1;
	arg.fNoSenseCase = 1;
	arg.iItem = 0;
	arg.fBack = fBack;
	txSort(textList,&arg);
	txJumpFileTop(textList);
	return TRUE;
}

static BOOL MoveListPara(TX* textList, BOOL fPrev)
{
	// textList ̒ȉ㉺ړ
	// fPrev = ցH
	if (txGetTextSize(textList)<2 || (fPrev && textList->npara<2) ) return FALSE;
	txSelectQuit(textList);
	txJumpParaTop(textList);
	if (txIsCurEof(textList)) txPrevPara(textList);
	txSelectEx(textList,CLIP_PARACUR);
	txPrivatePush(textList);
	txSelectDelete(textList);
	if (fPrev) txPrevPara(textList);
	else       txNextPara(textList);
	txPrivatePop(textList);
	return TRUE;
}

static BOOL DelListPara(TX* textList)
{
	// textList ̒i̍폜
	if (!txDeletePara(textList)) return FALSE;
	if (txIsCurEof(textList)) txPrevPara(textList);
	return TRUE;
}

static BOOL SetSaveListPathDir(TX* textList)
{
	// p_szSaveDir  txetList ̃tpX̃tH_̃pX擾
	txstr szPath;
	if (!txGetPara(textList,szPath)) return FALSE;
	pathSetFileName(szPath,"");
	if (strlen(szPath)>3) pathFormDir(szPath);
	p_szSaveDir = szPath;
	return TRUE;
}

static void InsertAddText(TX* textBox)
{
	// textBox ɒǉeLXg̓e}
	txstr szAddTextPath;
	SetAddTextPath(szAddTextPath);
	if (fileIsExist(szAddTextPath)) {
		TX* textTmp = textopenEx(szAddTextPath,TXO_KCAUTO | TXO_CRAUTO);
		if (txGetTextSize(textTmp)>0) txInsertText(textBox,textTmp);
		else                          txInsert(textBox," %i.\"%f\"\n");
		textclose(textTmp);
	} else {
		txInsert(textBox," %i.\"%f\"\n");
	}
	txJumpFileTop(textBox);
}

static void FlushTextBox(TX* textBox)
{
	// textBox ̕\ݒ肵čXV
	textBox->fMyFont  = 1;
	strcpy(textBox->lfFaceName,"lr SVbN");
	textBox->lfHeight = 10;

	textBox->fReadMode    = 0;
	textBox->fDispLf      = 1;
	textBox->fDispEof     = 1;
	textBox->fDispTab     = 1;
	textBox->fDispFind    = 0;
	textBox->fDispControl = 1;
	textBox->fDispComment = 0;
	textBox->fScrollBarH  = 0;
	textBox->fScrollBarV  = 1;
	textBox->fDispLine    = 0;
	textBox->fDispUnder   = 0;
	textBox->fApfuBeamtab = 0; 
	textBox->fWidthInfinity        = 1;
	textBox->fNoDispHeadlineString = 0;
	textBox->fDispHeadlineBold     = 0;
	textBox->fDispRightMargin      = 0;
	textBox->fEdit = 0;
	textBox->dlgcode = DLGC_WANTALLKEYS;	// eLXg{bNX Enter̓͂\ɂ

	txKeyLoad(textBox);
	//txKeyLoadFrame(textBox);
	txFlush(textBox);
}

static BOOL CALLBACK dlgprocMain(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// vV[W
	HDIALOG hd = dialogFromHwnd(hwnd);
	TX* text = hd->text;
	HWND hwndMsgBox = GetDlgItem(hwnd,IDD_MSGBOX);
	switch (uMsg) {
		case WM_INITDIALOG: {
			wndSetCenter(hwnd);	// wz_main.exe /fz_JOINT.txe ŒPƋNA_CAO[ɕ\̂ŒփZbg
			PostMessage(hwnd,WM_TXUSER,0,0);
			break;
		}
		case WM_COMMAND: {
			switch (LOWORD(wParam)) {

				case IDD_NOEXTBINARY:
					dialogReadItem(hd,IDD_NOEXTBINARY);
					__prmSave();
					break;

				case IDD_ADDTEXT:
					PostMessage(hwnd,WM_TXUSER,0,0);
					break;

				case IDD_SAVECODE:
					dialogReadItem(hd,IDD_SAVECODE);
					EnableDlgItem(hwnd,IDD_SAVEKC,g_fSaveCode);
					EnableDlgItem(hwnd,IDD_SAVECR,g_fSaveCode);
					break;

				case IDD_GETDIR_DESKTOP: {
					txstr szShellPath;
					if (GetShellPath(0,szShellPath)) {
						p_szSaveDir = szShellPath;
						dialogWriteItem(hd,IDD_SAVEDIR);
					}
					break;
				}
				case IDD_GETDIR_MYDOCS: {
					txstr szShellPath;
					if (GetShellPath(1,szShellPath)) {
						p_szSaveDir = szShellPath;
						dialogWriteItem(hd,IDD_SAVEDIR);
					}
					break;
				}
				case IDD_GETDIR_DATADIR:
					if (!txGetTextSize(g_textList) && MessageBox(GetActiveWindow(),"uAt@C̈ꗗv֓ǂݍłsĂB","\m.c",MB_OK|MB_ICONINFORMATION)) break;
					dialogReadItem(hd,IDD_LISTBOX);
					if (SetSaveListPathDir(g_textList)) dialogWriteItem(hd,IDD_SAVEDIR);
					break;

				case IDD_GETLIST_SELDIR: {
					txstr szPath, szCaption = "At@C̃tH_I";
					BOOL ret = FALSE;
					if (__SHELL_DIALOG__==0) {
					// WZ`̏^̃tH_̎Qƃ_CAO
						if (text) szPath = text->szfilename;
						pathSetFileName(szPath,"");
						ret = uiSelectFolder(szPath,szCaption);
					} else {
					// Windows`tH_̎Qƃ_CAO
						ret = mySHBrowseForFolder(hwnd,szPath,szCaption);
					}
					if (ret) {
						dialogRead(hd);
						if (GetFileList(g_textList,szPath,p_fNoExtBinary)) {
							SortList(g_textList,FALSE);
							if (p_fSaveCmpPath && SetSaveListPathDir(g_textList)) dialogWriteItem(hd,IDD_SAVEDIR);
						}
						dialogWriteItem(hd,IDD_LISTBOX);
					}
					return TRUE;
				}
				case IDD_GETLIST_HISTDIR: {
					txstr szPath;
					if (GetHistPathDialog(szPath)) {
						dialogRead(hd);
						if (GetFileList(g_textList,szPath,p_fNoExtBinary)) {
							SortList(g_textList,FALSE);
							if (p_fSaveCmpPath && SetSaveListPathDir(g_textList)) dialogWriteItem(hd,IDD_SAVEDIR);
							dialogWriteItem(hd,IDD_LISTBOX);
						}
					}
					break;
				}
				case IDD_GETLIST_PREVDIR: {
					dialogRead(hd);
					if (GetFileList(g_textList,p_szDataDir,p_fNoExtBinary)) {
						SortList(g_textList,FALSE);
						if (p_fSaveCmpPath && SetSaveListPathDir(g_textList)) dialogWriteItem(hd,IDD_SAVEDIR);
						dialogWriteItem(hd,IDD_LISTBOX);
					}
					break;
				}

				case IDD_BOOTHISTDIR:
					dialogReadItem(hd,IDD_BOOTHISTDIR);
					__prmSave();
					break;

				case IDD_SORT_FORWARD:
					dialogReadItem(hd,IDD_LISTBOX);
					if (SortList(g_textList,FALSE)) dialogWriteItem(hd,IDD_LISTBOX);
					break;
				case IDD_SORT_BACK:
					dialogReadItem(hd,IDD_LISTBOX);
					if (SortList(g_textList,TRUE)) dialogWriteItem(hd,IDD_LISTBOX);
					break;

				case IDD_MOVE_PREV:
					dialogReadItem(hd,IDD_LISTBOX);
					if (MoveListPara(g_textList,TRUE)) dialogWriteItem(hd,IDD_LISTBOX);
					break;
				case IDD_MOVE_NEXT:
					dialogReadItem(hd,IDD_LISTBOX);
					if (MoveListPara(g_textList,FALSE)) dialogWriteItem(hd,IDD_LISTBOX);
					break;

				case IDD_DEL_ONE:
					dialogReadItem(hd,IDD_LISTBOX);
					if (DelListPara(g_textList)) dialogWriteItem(hd,IDD_LISTBOX);
					break;

				case IDD_CONNECT: {
				// A
					dialogRead(hd);
					if (!txGetTextSize(g_textBox)) p_fAddText = FALSE;

					BOOL ret = FALSE;
					txstr szSaveName = __SAVE_FILENAME__;
					if (text) {
					// text ̎s
						HWND hwndStatus = text->hwndStatusbar;	// Xe[^Xo[nh
						text->hwndStatusbar = NULL;				// Xe[^Xo[\~
						ret = ConnectListFile(hwndMsgBox,g_textList,g_textBox,p_szSaveDir,szSaveName,p_fAddLf,p_fAddText,p_iAddTextMode,g_fSaveCode,p_iSaveKc,p_iSaveCr);
						text->hwndStatusbar = hwndStatus;		// Xe[^Xo[\ĊJ
					} else {
					// TXEN
						ret = ConnectListFile(hwndMsgBox,g_textList,g_textBox,p_szSaveDir,szSaveName,p_fAddLf,p_fAddText,p_iAddTextMode,g_fSaveCode,p_iSaveKc,p_iSaveCr);
					}

					if (!ret) return TRUE;

					if (p_fAddText && g_textBox->fEdit) {
						txstr szAddTextPath;
						SetAddTextPath(szAddTextPath);
						txSaveTo(g_textBox,szAddTextPath);
					}

					txstr szPath;
					txJumpFileTop(g_textList);
					if (txGetPara(g_textList,szPath)) {
						pathSetFileName(szPath,"");
						if (strlen(szPath)>3) pathFormDir(szPath);
						p_szDataDir = szPath;
						p_fSaveCmpPath = (strcmp(p_szDataDir,p_szSaveDir)==0);

						HSTRBLK sb = historyOpen(__HIST_NAME__,512);
						sbAddHist(sb,p_szDataDir);
						historyClose(__HIST_NAME__,sb);

						__prmSave();
					}
					break;
				}

				case IDD_SHELL_SETUP:
					ShellInstallTextJointDialog();
					break;

				case IDD_HELP:
					HelpAbout();
					break;

			}
			break;
		}
		case WM_TXUSER: {
			dialogReadItem(hd,IDD_ADDTEXT);
			EnableDlgItem(hwnd,IDD_ADDTEXTMODE,  (p_fAddText!=0));
			EnableDlgItem(hwnd,IDD_ADDTEXTMODE+1,(p_fAddText!=0));
			EnableDlgItem(hwnd,IDD_ADDTEXTBOX,(p_fAddText!=0));
			break;
		}
	}
	return FALSE;
}

static void MainDialog(BOOL fTxe, BOOL fBootDir, txstr szDataDir)
{
	// C_CAO

	// fBootDir  = w̃tH_̃t@CꗗǂݍŋNH
	// szDataDir = fBootDir  TRUE ̎̃tH_̃pX
	// fTxe      = TXENH

	if (!strlen(__SAVE_FILENAME__) && MessageBox(GetActiveWindow(),"vOG[\n\n__SAVE_FILENAME__ ̕񂪒`Ă܂B","\m.c",MB_OK|MB_ICONSTOP)) return;
	txstr szNoNameChar = "\\/:,;*?\"<>|";
	if (strchrs(__SAVE_FILENAME__,szNoNameChar) && MessageBox(GetActiveWindow(),"vOG[\n\n__SAVE_FILENAME__ Ƀt@CɎgpłȂ݂܂B\n\nt@CɎ͎̕g܂B\n\n"+szNoNameChar,"\m.c",MB_OK|MB_ICONSTOP)) return;

	g_textList = textnew();		// Xg{bNXp
	g_textBox  = textnew();		// eLXg{bNXp
	InsertAddText(g_textBox);	// eLXg{bNXɒǉeLXg̓e}

	if (fBootDir && strlen(szDataDir) && pathIsDirectory(szDataDir)) {
	// szDataDir tH_̃t@Cꗗǂݍ݂ŋN
		if (GetFileList(g_textList,szDataDir,p_fNoExtBinary)) {
			SortList(g_textList,FALSE);
			if (p_fSaveCmpPath) SetSaveListPathDir(g_textList);
		}
	}

	#define MAX_LISTWIDTH  100		// Xg{bNX̉̍ől
	int lcx = 18, lcxBox = __LIST_WIDTH__ > MAX_LISTWIDTH ? MAX_LISTWIDTH : __LIST_WIDTH__;
	txstr szTitle;
	sprintf(szTitle,"%s%s  -  Ver.%s",fTxe ? "WZ":"",__MACRO_TITLE__,__MACRO_VER__);
	// TXEN Windows̃vZXƃ^XNo[̕\ WZ ƕ悤ɓ "WZ " t
	HDIALOG hd = dialog(szTitle);
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocMain);
#pragma warnfuncnotcall+
	dialogSetFocus(hd,IDD_GETLIST_SELDIR);
	dialogSpace(hd);

	dialogSetH(hd);

	txstr szMsg = "ꗗ̏ԂɘA܂";
	dialogCaption(hd,"At@C(&L):");
	dialogSetPosX(hd,74);
	dialogControlID(hd,IDD_MSGBOX);
	dialogCaptionDynamic(hd,szMsg,40);
	dialogLFSetV(hd);

	dialogControlID(hd,IDD_LISTBOX);
	dialogList(hd,NULL,g_textList,lcxBox,11);

	dialogSetPosY(hd,dialogGetPosY(hd)-3);
	dialogControlID(hd,IDD_ADDLF);
	dialogCheck(hd,"At@C̕ɉsȂ͉s₤ (&N)",&p_fAddLf);

	dialogSetH(hd);
	dialogControlID(hd,IDD_ADDTEXT);
	dialogCheck(hd,"eAɎ̃eLXgǉ (&T)",&p_fAddText);
	dialogIndent(hd,-1);
	dialogControlID(hd,IDD_ADDTEXTMODE);
	dialogChoiceRadio(hd,&p_iAddTextMode
		,""
		,""
		,NULL
	);

	dialogLFSetV(hd);

	dialogIndent(hd,3);
	// --- textBox Start ---
	dialogControlID(hd,IDD_ADDTEXTBOX);
	dialogEditWz(hd,NULL,g_textBox,lcxBox-3,4,WS_VSCROLL);
	FlushTextBox(g_textBox);
	// --- textBox End -----
	dialogSetPosY(hd,dialogGetPosY(hd)-1);
	dialogCaption(hd,"(@%f@̓t@CA@%i@̓t@Cԍ@ƂȂ܂ )");
	dialogLF(hd);

	dialogHeadline(hd,"At@C",lcxBox);

	dialogSetH(hd);
	dialogControlID(hd,IDD_SAVECODE);
	dialogCheck(hd,"ۑ̕R[hw (&C)",&g_fSaveCode);
	dialogSetPosY(hd,dialogGetPosY(hd)-2);

	dialogSetPosX(hd,132);
	dialogControlEnable(hd,g_fSaveCode);
	dialogControlID(hd,IDD_SAVEKC);
#if WZFUNC_TX3
	dialogChoice(hd,NULL,0,&p_iSaveKc,13
		," SHIFT-JIS"
		," JIS"
		," EUC"
		," Unicode"
		," Unicodex^"
		," UTF-8"
		,"  (WZ5)"
		,NULL
	);
#else
	dialogChoice(hd,NULL,0,&p_iSaveKc,13
		," SHIFT-JIS"
		," JIS"
		," EUC"
		," Unicode"
		," Unicodex^"
		," UTF-8"
		,NULL
	);
#endif
	dialogControlEnable(hd,g_fSaveCode);
	dialogControlID(hd,IDD_SAVECR);
	dialogChoice(hd,NULL,0,&p_iSaveCr,13
		," CR+LF"
		," CR"
		," LF"
		,NULL
	);
	dialogLFSetV(hd);

	dialogSpace(hd);
	dialogSpace(hd);

	dialogCaption(hd,"At@C i"+ __SAVE_FILENAME__ +"j ̕ۑꏊ itH_j (&A)");
	dialogSetPosY(hd,dialogGetPosY(hd)-2);
	dialogControlID(hd,IDD_SAVEDIR);
	dialogControlRefer(hd,"-d");
	dialogTxstr(hd,NULL,0,p_szSaveDir,lcxBox-6);
	dialogSetH(hd);
	dialogControlID(hd,IDD_GETDIR_DESKTOP);
	dialogPushbutton(hd,"fXNgbv(&K)",18);
	//dialogIndent(hd,-1);
	dialogControlID(hd,IDD_GETDIR_MYDOCS);
	dialogPushbutton(hd,"}C hLg(&M)",18);
	//dialogIndent(hd,-1);
	dialogControlID(hd,IDD_GETDIR_DATADIR);
	dialogPushbutton(hd,"At@CƓꏊ(&I)",30);
	dialogSetV(hd);
	dialogLFV(hd);
	dialogIndent(hd,1);

	dialogSetPosLF(hd);		// sx[Xʒuɐݒ

	dialogHeadline(hd,"ꗗ֓ǂݍ",lcx);
		dialogControlID(hd,IDD_GETLIST_SELDIR);
		dialogCmdDefault(hd,"tH_I(&F) ...",lcx);	// Default ɂ̂ Pushbutton ɂȂ
		//dialogPushbuttonBig(hd,"tH_I(&A)",lcx);
		dialogSpace(hd);
		dialogControlID(hd,IDD_GETLIST_HISTDIR);
		dialogPushbutton(hd,"ŋ߂̃tH_(&R) ...",lcx);
		dialogControlID(hd,IDD_GETLIST_PREVDIR);
		dialogPushbutton(hd,"ÕtH_(&P)",lcx);
		dialogSpace(hd);
		dialogSpace(hd);

		txstr sz;
		dialogControlID(hd,IDD_BOOTHISTDIR);
		dialogCheck(hd,"NɑO &,",&p_fBootHistDir);
		dialogSetPosY(hd,dialogGetPosY(hd)-2);
		sz = "@@tH_ǂݍ";
		dialogCaptionDynamic(hd,sz,17);

		dialogControlID(hd,IDD_NOEXTBINARY);
		dialogCheck(hd,"oCi &.",&p_fNoExtBinary);
		dialogSetPosY(hd,dialogGetPosY(hd)-2);
		sz = "@@ ǂݍ܂Ȃ";
		dialogCaptionDynamic(hd,sz,17);

	dialogHeadline(hd,"ꗗ",lcx);
		dialogSetH(hd);
		dialogControlID(hd,IDD_SORT_FORWARD);
		dialogPushbutton(hd,"\[g &; ",lcx/2);
		dialogIndent(hd,-1);
		dialogControlID(hd,IDD_SORT_BACK);
		dialogPushbutton(hd,"\[g &;",lcx/2);
		dialogLF(hd);
		dialogSpaceV(hd);
		dialogControlID(hd,IDD_MOVE_PREV);
		dialogPushbutton(hd,"1 &[",lcx/2);
		dialogIndent(hd,-1);
		dialogControlID(hd,IDD_MOVE_NEXT);
		dialogPushbutton(hd,"1 &]",lcx/2);
		dialogLFSetV(hd);
		dialogSpaceV(hd);
		dialogControlID(hd,IDD_DEL_ONE);
		dialogPushbutton(hd,"PO(&D)",lcx);
		dialogSpace(hd);
		dialogSpace(hd);

	dialogHeadline(hd,"A",lcx);
		dialogControlID(hd,IDD_CONNECT);
		dialogCmd(hd,"A̎s(&Y)",lcx);
		dialogCancel(hd,lcx);
		dialogSpace(hd);
		dialogSpace(hd);
		dialogSpace(hd);
		dialogSetH(hd);
		dialogControlID(hd,IDD_SHELL_SETUP);
		dialogPushbuttonBig(hd,"&Shello^...",lcx/2);
		dialogIndent(hd,-1);
		dialogControlID(hd,IDD_HELP);
		dialogPushbuttonBig(hd,"wv(&H)",lcx/2);
		dialogLFSetV(hd);

	dialogOpen(hd);
	textclose(g_textList);
	textclose(g_textBox);
}


//## 蓖ėp֐

void set_path02(TX* text)
{
	// Cӂ̃tH_̃t@CꗗǂݍŋNTv֐(2)
	txstr szDataDir = \"C:\My Documents\Ap";	// "C:\My Documents\Ap"
	MainDialog(FALSE,TRUE,szDataDir);
}

void set_path01(TX* text)
{
	// Cӂ̃tH_̃t@CꗗǂݍŋNTv֐(1)
	txstr szDataDir = \"C:\Windows\޽į\Ap";	// "C:\Windows\޽įߘAp"
	MainDialog(FALSE,TRUE,szDataDir);
}

void shell_setup(TX* text)
{
	// Shellj[o^_CAO    // main_CAÓuShello^v{^ŋN\
	ShellInstallTextJointDialog();
}

void main(TX* text)
{
	// ʏN  // TXENȂ WZ̋N
	txstr szDataDir;
	if (p_fBootHistDir) {
	// ÕtH_
		szDataDir = p_szDataDir;
	} else {
	// ݂̃̕tH_
		txstr szPath = text->szfilename;
		pathSetFileName(szPath,"");
		pathFormDir(szPath);
		strcpy(szDataDir,szPath);
	}
	MainDialog(FALSE,TRUE,szDataDir);
}


//## PƋNpiwz_main.exe /fz_JOINT.txe Npj

HWND TxeMain(wchar* wszcmdline)
{
	txstr szCmdline, szDataDir;
	wstrtostr(wszcmdline,-1,szCmdline,CCHPATHNAME);

	// -f"pX" tR}hCΉ
	BOOL fOptPath = FALSE;	
	// fOptPath = -f""()  szDataDir Ɏ擾łH
	if (strstr(szCmdline,"-f\"")) {
		szDataDir = strstr(szCmdline,"-f\"");
		szDataDir = strrear(szDataDir,3);
		if (strchr(szDataDir,'"')) {
			szDataDir = strleft(szDataDir,strlen(szDataDir) - strlen(strchr(szDataDir,'"')));
			if (strlen(szDataDir)>3) pathFormDir(szDataDir);
			if (strlen(szDataDir)) fOptPath = TRUE;
			//information("%s",szDataDir);
		}
	}

	if (fOptPath && pathIsDirectory(szDataDir)) {
	// szDataDirtH_̎At@CꗗǂݍŋN
		MainDialog(TRUE,TRUE,szDataDir);
	} else if (fOptPath && fileIsExist(szDataDir)) {
	// szDataDirt@C̎At@C̃tH_̃t@CꗗǂݍŋN
		pathSetFileName(szDataDir,"");
		if (strlen(szDataDir)>3) pathFormDir(szDataDir);
		MainDialog(TRUE,TRUE,szDataDir);
	} else {
		if (p_fBootHistDir) {
		// ÕtH_ǂݍŋN
			szDataDir = p_szDataDir;
			MainDialog(TRUE,TRUE,szDataDir);
		} else {
		// ǂݍ܂ɋN
			MainDialog(TRUE,FALSE,szDataDir);
		}
	}
	return NULL;
}


